;NSIS Modern User Interface version 1.70
;UKW Tools install script
;Written by Jonathan Naylor

  SetCompressor lzma

;--------------------------------
;Include Modern UI

  !include "MUI.nsh"

;--------------------------------
;Configuration

  ;General
  Name "WS Tools 0.4.8d"
  OutFile "WSTools.exe"

  ;Folder selection page
  InstallDir "$PROGRAMFILES\WS Tools"
  
  ;Get install folder from registry if available
  InstallDirRegKey HKCU "Software\G4KLX\wstools\General" "inst_path"

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_LICENSE "c:\msys\1.0\home\jsn\wstools-0.4.8d\COPYING"
  !insertmacro MUI_PAGE_DIRECTORY

  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Installer Sections

Section "UKW Tools Program Files" SecProgram

  SetOutPath "$INSTDIR"
  
  File c:\msys\1.0\home\jsn\wstools-0.4.8d\jt44\JT44.exe
  File c:\msys\1.0\home\jsn\wstools-0.4.8d\fsk441\FSK441.exe
  File c:\wxWindows-2.4.2\lib\wxmsw242.dll
  File c:\msys\1.0\home\jsn\fftw3win32mingw\fftw3.dll
  File /oname=Licence.txt c:\msys\1.0\home\jsn\wstools-0.4.8d\COPYING
  File /oname=Changes.txt c:\msys\1.0\home\jsn\wstools-0.4.8d\CHANGES
  File /oname=ToDo.txt    c:\msys\1.0\home\jsn\wstools-0.4.8d\TODO
  File /oname=ReadMe.txt  c:\msys\1.0\home\jsn\wstools-0.4.8d\README
  File c:\msys\1.0\home\jsn\wstools-0.4.8d\meta\fsk441.ico
  File c:\msys\1.0\home\jsn\wstools-0.4.8d\meta\jt44.ico

  ;Create start menu entry
  CreateDirectory "$SMPROGRAMS\WS Tools"
  CreateShortCut "$SMPROGRAMS\WS Tools\FSK441.lnk"    "$INSTDIR\FSK441.exe" "" "$INSTDIR\fsk441.ico"
  CreateShortCut "$SMPROGRAMS\WS Tools\JT44.lnk"      "$INSTDIR\JT44.exe"   "" "$INSTDIR\jt44.ico"
  CreateShortCut "$SMPROGRAMS\WS Tools\Licence.lnk"   "$INSTDIR\Licence.txt"
  CreateShortCut "$SMPROGRAMS\WS Tools\ReadMe.lnk"    "$INSTDIR\ReadMe.txt"
  CreateShortCut "$SMPROGRAMS\WS Tools\Changes.lnk"   "$INSTDIR\Changes.txt"
  CreateShortCut "$SMPROGRAMS\WS Tools\ToDo.lnk"      "$INSTDIR\ToDo.txt"
  CreateShortCut "$SMPROGRAMS\WS Tools\Uninstall.lnk" "$INSTDIR\Uninstall.exe"

  ;Create a Desktop short cut
  CreateShortCut "$DESKTOP\FSK441.lnk" "$INSTDIR\FSK441.exe" "" "$INSTDIR\fsk441.ico"
  CreateShortCut "$DESKTOP\JT44.lnk"   "$INSTDIR\JT44.exe"   "" "$INSTDIR\jt44.ico"

  ;Store install folder
  WriteRegStr HKCU "Software\G4KLX\wstools\General" "inst_path" $INSTDIR

  ;Store Windows uninstall keys
  WriteRegStr   HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\WS Tools" "DisplayName"      "WS Tools"
  WriteRegStr   HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\WS Tools" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\WS Tools" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\WS Tools" "NoRepair" 1

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd

;--------------------------------
;Uninstaller Section

Section "Uninstall"

  Delete "$INSTDIR\FSK441.exe"
  Delete "$INSTDIR\JT44.exe"
  Delete "$INSTDIR\wxmsw242.dll"
  Delete "$INSTDIR\Uninstall.exe"
  Delete "$INSTDIR\Changes.txt"
  Delete "$INSTDIR\Licence.txt"
  Delete "$INSTDIR\ReadMe.txt"
  Delete "$INSTDIR\ToDo.txt"
  Delete "$INSTDIR\fsk441.ico"
  Delete "$INSTDIR\jt44.ico"

  Delete "$DESKTOP\FSK441.lnk"
  Delete "$DESKTOP\JT44.lnk"

  RMDir "$INSTDIR"

  Delete "$SMPROGRAMS\WS Tools\*.*"
  RMDir  "$SMPROGRAMS\WS Tools"

  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\WS Tools"

  DeleteRegKey HKCU "Software\G4KLX\wstools"

SectionEnd
